#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Artober - Ice galleriesMod01.fsh  by  Flopine  
//https://www.shadertoy.com/view/flyBzV
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Code by Flopine

// Thanks to wsmind, leon, XT95, lsdlive, lamogui, 
// Coyhot, Alkama,YX, NuSan, slerpy, wwrighter 
// BigWings, FabriceNeyret and Blackle for teaching me

// Thanks LJ for giving me the spark :3

// Thanks to the Cookie Collective, which build a cozy and safe environment for me 
// and other to sprout :)  
// https://twitter.com/CookieDemoparty


#define circle(u,s) (length(u)-s)

float multiscale_truchet (vec2 uv, float seed)
{
   vec2 id = floor(uv);
   uv = fract(uv)-.5;
   
   float s, noise = texture2D(texture0, (id+seed)*0.1, 0.).x; //textureLod
   vec2 uu;
   if (noise<.5) uv.x *=-1.;
   
   if (noise>0.6)
   {
       uu = mod(uv,0.5)-0.25;
       s = uu.x > -uu.y ? 1. : -1.;
       vec2 uuu = uu-s*.25;
       float d = abs(circle(uuu, 0.25));
       return .25-d;
   }
   else
   {
       s = uv.x > -uv.y ? 1. : -1.;
       uu = uv-s*.5;
       float c1 = abs(circle(uu, 0.5));
       uu = abs(uv)-.5;
       float c2 = circle(uu, 0.005);
       return min(c1,c2);
   }   
}

// iq's distance function
// https://iquilezles.org/articles/distfunctions/
float extrude (vec3 p, float d, float h)
{
    vec2 w = vec2( d, abs(p.z) - h );
    return min(max(w.x,w.y),0.0) + length(max(w,0.0));
}

float SDF (vec3 p)
{
    p.z += iTime;
    
    float per = 5.;
    float id = floor(p.z/per);
    p.z = mod(p.z, per)-per*.5;
   
    float scene = extrude(p.xyz, multiscale_truchet(p.xy, id), 0.05)-0.22;
    scene = max(-length(p)+.3, scene);
    
    return scene;
}

vec3 gn (vec3 p)
{
    vec2 e = vec2(0.001,0.);
    return normalize(SDF(p)-vec3(SDF(p-e.xyy),SDF(p-e.yxy),SDF(p-e.yyx)));
}

float AO (vec3 p, vec3 n, float e)
{return clamp( SDF(p+e*n)/e, 0., 1. );}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{    
    vec2 uv = (2.*fragCoord-iResolution.xy)/iResolution.y;
    vec3 ro = vec3(0.001,0.001, -3.), rd=normalize(vec3(uv,1.)),
    p=ro, col = vec3(0.), l=normalize(vec3(-3.,1.,-4.));
    
    bool hit=false;
    
    for(float i=0.; i<64.; i++)
    {
        float d = SDF(p);
        if (d<0.001)
        {
            hit=true;
        }
        d = max(abs(d),0.001);
        p += d*rd*0.6;
    }
    float t = length(p-ro);
    if(hit)
    {
        vec3 n = gn(p);
        float ao = AO(p,n,0.05)+AO(p,n,0.15)+AO(p,n,0.2);
        col = vec3(0.4,0.8,0.9)*(ao/2.);
    }    
    col = mix(col, vec3(0.,0.01,0.1), 1.-exp(-0.01*t*t));

    fragColor = vec4(sqrt(col),1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

